unit MbFileTools01;
(*
   ========================================================================
    MicroBase.
           .
   ========================================================================
   :
   1)  TRecBuf (   TMicroBase),  :
      1.1        
      1.2       
             .
   2)  TMicroBase,   :
      2.1  ( /)   MicroBase
      2.2   MicroBase
      2.3         
      2.4    (   )   
   ========================================================================
   ()  ,    , , .
   ========================================================================
*)

interface
uses //  
     SysUtils, Dialogs;

//------------------------------------------------------------------------
//    (     )
const rsDeletedRec = 0;      //    
      rsDataRec    = 1;      //     

// =====================================================================
//     TRecBuf  -  
// =====================================================================
type TRecBuf = class(TObject)
  protected
     fDebugOk  : boolean;    //     
     fRecBufOk : boolean;    //      
     fRecSize  : cardinal;   //    ( + )
     fPRecBuf  : pointer;    //    
     fDatSize  : cardinal;   //     
     fPRecDat  : pointer;    //      
     // ----------------------------------------------
     //      
     procedure Clear();
     //     
     procedure DebugMessage(Title : string; ErrCode : integer);
     //   -  
     constructor Create(RqDatSize : cardinal);
     //    
     procedure Free();
  public
     // -------   ----------------------
     //      
     function GetRecDat(RqPDat : pointer) : boolean;
     //      
     function SetRecDat(RqPDat : pointer) : boolean;
     // --------   --------------------
     //   -     
     property RecBufOk : boolean read fRecBufOk;
     //      
     property pRecBuf  : pointer read fPRecBuf;
     //     
     property RecSize  : cardinal read fRecSize;
     //        
     property pRecDat  : pointer read fPRecDat;
     //       
     property DatSize  : cardinal read fDatSize;
     // /   (  False)
     property DebugOn : boolean read fDebugOk write fDebugOk;
end;

// =====================================================================
//     TMicroBase (     )
// =====================================================================
type TMicroBase = class(TRecBuf)
  private
     fFileName : string[255];  //  
     fOpenOk   : boolean;      //  -   
     fPFile    : pointer;      //     
     fFile     : file;         //   
     fErrCode  : integer;      //     
     fFilePos  : integer;      //   
     fRecIndx  : integer;      //     
     // -----------------------------------
     //     
     procedure SetRecHeader(RqRecStat : byte; RqRecIndx : integer);
     //  property RecStat
     function GetRecStat() : byte;
     //  property RecIndx
     function GetRecIndx() : integer;
  public
     // -----------------------------------
     //   - MicroBase
     constructor Create(RqDatSize : cardinal);
     //   MicroBase
     //   TRecBuf
     // -----------------------------------
     //  ( /)   MicroBase
     function OpenMicroBase (RqFileName : string) : boolean;
     //   MicroBase
     procedure CloseMicroBase();
     //          .
     function AddRecToFile() : integer;
     //         RqIndex
     //          nil.
     function ReadRecFromFile(RqIndex : integer) : pointer;
     //    (   RqIndex)   
     //      .
     function WriteRecToFile(RqRecStat : byte;
                             RqIndex   : integer) : boolean;
     // -----------------------------------
     // True -         
     property OpenOk  : boolean read fOpenOk;
     //    ( )  (.  )
     property RecStat : byte read GetRecStat;
     //   (    )   
     property RecIndx : integer read GetRecIndx;
     // -----------------------------------
end;

// =====================================================================
// =====================================================================

implementation

// =====================================================================
//      TRecBuf
// =====================================================================
//   .
//       .
type TRecBufHead = packed record
  RecIdnt : byte;         //   
  RecStat : byte;         //   
  RecIndx : integer;      //   
end;
// ---------------------------------------------------------------------
//      
procedure TRecBuf.Clear();
begin
  //    () -    
  fRecBufOk := False;
  fRecSize  := 0;
  fPRecBuf  := nil;
  fDatSize  := 0;
  fPRecDat  := nil;
end;
// ---------------------------------------------------------------------
//     
procedure TRecBuf.DebugMessage(Title : string; ErrCode : integer);
var wStr : string;
begin
  if fDebugOk
  then begin
    wStr := Title;
    if ErrCode > 0 then wStr := wStr + #13#10 + SysErrorMessage(ErrCode);
    MessageDlg(wStr, mtError, [mbOk], 0);
  end;
end;
// ---------------------------------------------------------------------
// 31.01.2013
//   -  
constructor TRecBuf.Create(RqDatSize : cardinal);
begin
  inherited Create();
  try
     fDebugOk := False;          //     
     fDatSize := RqDatSize;      //     
     //     
     fRecSize := RqDatSize + SizeOf(TRecBufHead);
     fRecBufOk := False;         //      
     //     
     GetMem(fPRecBuf, fRecSize);
     fRecBufOk := True;          //     
     //        
     fPRecDat := Pointer(Integer(fPRecBuf) + SizeOf(TRecBufHead));
  except
     DebugMessage('      ',0);
  end;
end;
// ---------------------------------------------------------------------
// 31.01.2013
//   -  
procedure TRecBuf.Free();
begin
  if (fRecSize > 0) and (fPRecBuf <> nil)
  then begin
    //    
    try FreeMem(fPRecBuf, fRecSize); finally end;
  end;
  inherited Free();
end;
// ---------------------------------------------------------------------
// 31.01.2013
//       
function TRecBuf.GetRecDat(RqPDat : pointer) : boolean;
begin
  Result := False;
  if (RqPDat <> nil) and (fDatSize > 0) and (fPRecDat <> nil)
  then begin
     try  //       RqPDat
          //  (SourceAddr,  DestAddr,   Count);
          Move(fPRecDat^,   RqPDat^,    Integer(fDatSize));
          Result := True;
     except end;
  end;
end;
// ---------------------------------------------------------------------
// 31.01.2013
//       
function TRecBuf.SetRecDat(RqPDat : pointer) : boolean;
begin
  Result := False;
  if (RqPDat <> nil) and (fDatSize > 0) and (fPRecDat <> nil)
  then begin
     try  //      RqPDat   
          //  (SourceAddr,  DestAddr,   Count);
          Move(RqPDat^,     fPRecDat^,  Integer(fDatSize));
          Result := True;
     except end;
  end;
end;

// =====================================================================
//         TMicroBase
// =====================================================================
//   Mode    (file)  
//  Reset  CloseFile.     unit System.
// fmClosed = $D7B0;     {  }
// fmInput  = $D7B1;     {    }
// fmOutput = $D7B2;     {    }
// fmInOut  = $D7B3;     {    /}

//       (file).
type // UnTyped File Record
  TPUnTpFileRec = ^TUnTpFileRec;
  TUnTpFileRec  = packed record
    Handle  : Integer;   //   
    Mode    : Word;      //      
    Flags   : Word;      //   
    RecSize : Cardinal;  //    
    //       
end;

//     FileMode,    unit System
//      Reset  
//   .     unit SysUtils.
// fmOpenRead       = $0000;
// fmOpenWrite      = $0001;
// fmOpenReadWrite  = $0002;

// ---------------------------------------------------------------------
//   MicroBase
constructor TMicroBase.Create(RqDatSize : cardinal);
begin
   inherited Create(RqDatSize);
   fDebugOk  := False;        //   
   fFileName := '';           //    
   fOpenOk   := False;        //    
   fPFile    := addr(fFile);  //    .
   fFilePos  := -1;           //   
   fRecIndx  := -1;           //     
end;

// ---------------------------------------------------------------------
//     
procedure TMicroBase.SetRecHeader(RqRecStat : byte; RqRecIndx : integer);
begin
  if fPRecBuf <> nil
  then begin
     TRecBufHead(fPRecBuf^).RecIdnt := Ord('R');
     TRecBufHead(fPRecBuf^).RecStat := RqRecStat;
     TRecBufHead(fPRecBuf^).RecIndx := RqRecIndx;
  end;
end;

//  property RecStat
function TMicroBase.GetRecStat() : byte;
begin
  Result := 0;
  if fPRecBuf <> nil then Result := TRecBufHead(fPRecBuf^).RecStat;
end;

//  property RecIndx
function TMicroBase.GetRecIndx() : integer;
begin
  Result := -1;
  if fPRecBuf <> nil then Result := TRecBufHead(fPRecBuf^).RecIndx;
end;

// ---------------------------------------------------------------------
// 31.01.2013
//      /
function TMicroBase.OpenMicroBase (RqFileName : string) : boolean;
begin
  Result := False;
  //   ( )
  if not FileExists(RqFileName) then Exit;
  //   1 ( )
  if not fRecBufOk
  then begin
     DebugMessage('  (  ): '
                  + #13#10 + RqFileName, 0);
     Exit;
  end;
  //   (  ,  )
  if (not fOpenOk) and fRecBufOk
  then begin
    fFilePos  := -1;                //   
    fRecIndx  := -1;                //     
    try
      Assign(fFile, RqFileName);    //   fFile   
      {$I-}
      FileMode := fmOpenReadWrite;  //   OpenReadWrite
      Reset(fFile, fRecSize);       // Open -  
      {$I+}
      fErrCode := IOResult();       //     I/O
      if fErrCode > 0
      then begin
         DebugMessage('    : '
                     + #13#10 + RqFileName, fErrCode)
      end
      else begin
        //       /
        if TPUnTpFileRec(fPFile)^.Mode = fmInOut
        then begin
           fOpenOk   := True;
           fFileName := RqFileName;
           fFilePos  := 0;         //   
           Result    := fOpenOk;
        end
        else CloseFile(fFile);     //    
      end;
    except
      DebugMessage('     : '
                  + #13#10 + RqFileName, 0);
    end;
  end;
end; // of procedure TMicroBase.OpenMicroBase
// ---------------------------------------------------------------------
// 31.01.2013
//   MicroBase
procedure TMicroBase.CloseMicroBase();
begin
   //    
   if not (TPUnTpFileRec(fPFile)^.Mode = fmClosed)
   then begin
     try
        CloseFile(fFile);
     finally
        fOpenOk := False;
        fFilePos  := -1;      //   
        fRecIndx  := -1;      //     
     end;
   end;
end; // of procedure TMicroBase.CloseMicroBase
// ---------------------------------------------------------------------
//          .
function TMicroBase.AddRecToFile() : integer;
var RecCount : integer;
begin
   Result := FileSize(fFile);
   if fOpenOk and fRecBufOk
   then begin
      //      
      Seek(fFile, Result);
      fFilePos := FilePos(fFile);
      if Eof(fFile)
      then begin
         //     
         SetRecHeader(rsDataRec, fFilePos);
         //      
         BlockWrite(fFile, fPRecBuf^, 1, RecCount);
         fFilePos  := FilePos(fFile);
         //    ,    
         if RecCount = 1 then Result := FileSize(fFile);
      end;
   end;
end;
// ---------------------------------------------------------------------
//         RqIndex
//          nil.
function TMicroBase.ReadRecFromFile(RqIndex : integer) : pointer;
var RecCount : integer;
begin
   Result := nil;
   if fOpenOk and fRecBufOk
   then begin
     //      
     if (RqIndex >= 0) and (RqIndex < FileSize(fFile))
     then begin
        //     .
        Seek(fFile, RqIndex);
        fFilePos := FilePos(fFile);
        if RqIndex = fFilePos
        then begin
          //     
          BlockRead(fFile, fPRecBuf^, 1, RecCount);
          fFilePos := FilePos(fFile);
          //    ,
          //       
          if RecCount = 1
          then begin
             fRecIndx := RqIndex;  //     
             Result   := fPRecDat;
          end;
        end;
     end;
   end;
end;
// ---------------------------------------------------------------------
//    (   RqIndex)   
//      .
function TMicroBase.WriteRecToFile(RqRecStat : byte;
                                   RqIndex   : integer) : boolean;
var RecCount : integer;
begin
   Result := False;
   if fOpenOk and fRecBufOk
   then begin
     //      
     if (RqIndex >= 0) and (RqIndex < FileSize(fFile))
     then begin
        //     
        Seek(fFile, RqIndex);
        fFilePos := FilePos(fFile);
        if RqIndex = fFilePos
        then begin
          //     
          SetRecHeader(RqRecStat, RqIndex);
          //  () 
          BlockWrite(fFile, fPRecBuf^, 1, RecCount);
          fFilePos := FilePos(fFile);
          //    ,   !
          if RecCount = 1 then Result := True;
        end;
     end;
   end;
end;
// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================
end.
